/*
 * Decompiled with CFR 0.152.
 */
package net.raithsphere.pishock;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.raithsphere.pishock.config.PiShockModClientConfigs;
import net.raithsphere.pishock.config.PiShockModCommonConfigs;
import net.raithsphere.pishock.message.MessageHandler;
import org.slf4j.Logger;

@Mod(value="pishock")
public class pishock {
    public static final String MOD_ID = "pishock";
    public static final Logger LOGGER = LogUtils.getLogger();

    public pishock() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PiShockModClientConfigs.SPEC, "pishock.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PiShockModCommonConfigs.SPEC, "pishock-common.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(pishock::createConfigScreen)));
    }

    public static Screen createConfigScreen(Minecraft minecraft, Screen mainConfigScreen) {
        return new ErrorScreen((Component)Component.m_237113_((String)"PiShock Controller"), (Component)Component.m_237113_((String)"Sadly this needs to be configured in the toml located at config/pishock-common.toml "));
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        if (!e.getEntity().m_9236_().m_5776_() && e.getEntity() instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)e.getEntity();
            float now = p.m_21223_();
            float max = p.m_21233_();
            MessageHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> p), (Object)new MessageHandler.MessageDamageToClient(0.0f, now, max, 0));
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent e) {
        if (!e.getEntity().m_9236_().m_5776_() && e.getEntity() instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)e.getEntity();
            float damage = e.getAmount();
            float now = p.m_21223_();
            float max = p.m_21233_();
            MessageHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> p), (Object)new MessageHandler.MessageDamageToClient(damage, now, max, 1));
        }
    }

    @Mod.EventBusSubscriber(modid="pishock", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MessageHandler.register();
        }
    }
}

