/*
 * Decompiled with CFR 0.152.
 */
package net.raithsphere.pishock.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final Configurable<Byte> MODE;
    public static final Configurable<String> USERNAME;
    public static final Configurable<String> CODE;
    public static final Configurable<String> API_KEY;
    public static final Configurable<Integer> COOLDOWN;
    public static final Configurable<Boolean> TRIGGER;
    public static final Configurable<Double> DEATH_INTENSITY;

    public static void save() {
        MODE.save();
        USERNAME.save();
        CODE.save();
        TRIGGER.save();
        API_KEY.save();
        COOLDOWN.save();
        DEATH_INTENSITY.save();
        SPEC.save();
    }

    static {
        BUILDER.push("Configs for PiShock");
        BUILDER.comment("Configuration for PiShock");
        MODE = new Configurable<Byte>(BUILDER.define("Mode", (Object)0), (byte)0);
        USERNAME = new Configurable<String>(BUILDER.define("Username", (Object)"USERNAME"), "");
        CODE = new Configurable<String>(BUILDER.define("Code", (Object)"CODE"), "");
        TRIGGER = new Configurable<Boolean>((ForgeConfigSpec.ConfigValue<Boolean>)BUILDER.define("TriggerOnDeath", true), true);
        API_KEY = new Configurable<String>(BUILDER.define("ApiKey", (Object)"APIKEY"), "");
        COOLDOWN = new Configurable<Integer>(BUILDER.defineInRange("Cooldown", (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(60), Integer.class), 2);
        DEATH_INTENSITY = new Configurable<Double>(BUILDER.defineInRange("DeathIntensity", (Comparable)Double.valueOf(80.0), (Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(100.0), Double.class), 100.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static class Configurable<T> {
        ForgeConfigSpec.ConfigValue<T> config;
        private T val;

        public Configurable(ForgeConfigSpec.ConfigValue<T> config, T def) {
            this.config = config;
            this.val = def;
        }

        public void set(T t) {
            this.val = t;
        }

        public T get() {
            return this.val;
        }

        public void save() {
            if (this.config.get() != this.get()) {
                this.config.set(this.val);
            }
        }
    }
}

