/*
 * Decompiled with CFR 0.152.
 */
package net.raithsphere.pishock;

import com.mojang.logging.LogUtils;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.raithsphere.pishock.ConfigScreen;
import net.raithsphere.pishock.config.CommonConfig;
import net.raithsphere.pishock.message.MessageHandler;
import org.slf4j.Logger;

@Mod(value="pishock")
public class pishock {
    public static final String NAME = "Pishock Mod";
    public static final String MOD_ID = "pishock";
    public static final Logger LOGGER = LogUtils.getLogger();

    public pishock() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC, "pishock-common.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((BiFunction)new BiFunction<Minecraft, Screen, Screen>(){

            @Override
            public Screen apply(Minecraft minecraft, Screen screen) {
                return new ConfigScreen(screen);
            }
        })));
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        LivingEntity livingEntity;
        if (!e.getEntity().f_19853_.m_5776_() && (livingEntity = e.getEntity()) instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)livingEntity;
            float now = p.m_21223_();
            float max = p.m_21233_();
            MessageHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> p), (Object)new MessageHandler.MessageDamageToClient(0.0f, now, max, 0));
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent e) {
        LivingEntity livingEntity;
        if (!e.getEntity().f_19853_.m_5776_() && (livingEntity = e.getEntity()) instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)livingEntity;
            float damage = e.getAmount();
            float now = p.m_21223_();
            float max = p.m_21233_();
            MessageHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> p), (Object)new MessageHandler.MessageDamageToClient(damage, now, max, 1));
        }
    }

    @Mod.EventBusSubscriber(modid="pishock", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MessageHandler.register();
        }
    }
}

