/*
 * Decompiled with CFR 0.152.
 */
package net.raith.pishock;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.raith.pishock.PiShockConfig;
import net.raith.pishock.Utils;
import net.raith.pishock.network.ShockHandler;
import org.slf4j.Logger;

@Mod(value="pishock")
public class PiShock {
    public static final String MOD_ID = "pishock";
    public static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static Float previousHP = null;
    @Nullable
    private static Integer cooldownTimer = null;
    @Nullable
    private static Integer activeTimer = null;
    private static boolean deathShocked = false;

    public PiShock(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.addListener(this::onHurt);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PiShockConfig.SPEC);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    public void onHurt(PlayerTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            PiShock.resetSystem();
            return;
        }
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        if (player.isCreative() || player.isSpectator()) {
            PiShock.resetSystem();
            return;
        }
        float currentHP = player.getHealth();
        float maxHP = player.getMaxHealth();
        boolean isDead = player.isDeadOrDying();
        if (previousHP == null) {
            previousHP = Float.valueOf(currentHP);
            activeTimer = 100;
            return;
        }
        if (isDead && ((Boolean)PiShockConfig.PISHOCK_TRIGGER_ON_DEATH.get()).booleanValue() && !deathShocked) {
            deathShocked = true;
            Utils.unilog("Player is DEAD, LIGHT THEM UP!");
            new Thread(() -> ShockHandler.shock(((Integer)PiShockConfig.PISHOCK_INTENSITY.get()).intValue())).start();
        } else if (deathShocked && currentHP > 0.0f) {
            deathShocked = false;
        } else if (currentHP < previousHP.floatValue() && currentHP > 0.0f) {
            Utils.unilog("Player has been damaged");
            float damage = previousHP.floatValue() - currentHP;
            float max = (float)((Integer)PiShockConfig.PISHOCK_INTENSITY.get()).intValue() / 20.0f;
            int shockpower = (int)(damage * max);
            if (cooldownTimer == null || cooldownTimer <= 0) {
                Utils.unilog("Player has been damaged for %s zapping at %s based on %s".formatted(Float.valueOf(damage), shockpower, Float.valueOf(max)));
                new Thread(() -> ShockHandler.shock(shockpower)).start();
                cooldownTimer = 200;
            } else {
                Utils.unilog("Cooldown is active, remaining: " + cooldownTimer);
            }
        }
        if (cooldownTimer != null && cooldownTimer > 0) {
            Integer n = cooldownTimer;
            cooldownTimer = cooldownTimer - 1;
        }
        previousHP = Float.valueOf(currentHP);
    }

    private static void resetSystem() {
        cooldownTimer = null;
        previousHP = null;
        activeTimer = null;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info(Utils.unilog("PiShock initialized"));
    }

    @EventBusSubscriber(modid="pishock", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }

    public static enum PiShockMode {
        Shock(0),
        Vibrate(1),
        Beep(2);

        private final int value;

        private PiShockMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PiShockMode fromValue(int value) {
            for (PiShockMode mode : PiShockMode.values()) {
                if (mode.getValue() != value) continue;
                return mode;
            }
            return Shock;
        }
    }
}

